(* Proof Transformations: A Basic Example *)
(* Author: Nicolas Magaud *)
(* $Id: example.v,v 1.1 2006/01/22 14:21:38 magaud Exp $ *)

Parameter NAT:Set.
Parameter ZERO:NAT.
Parameter SUCC:NAT->NAT.

AddIso nat NAT.
AddIso O ZERO.
AddIso S SUCC.
Parameter INDUCTION:
  forall P:NAT->Prop,
    (P ZERO) -> (forall n:NAT, P n ->P (SUCC n)) -> forall n:NAT, P n.

AddIso nat_ind INDUCTION.

Parameter PLUS: NAT -> NAT -> NAT.

Axiom PLUS_1 : forall n:NAT, (PLUS ZERO n)=n.
Axiom PLUS_2 : forall n m:NAT, (PLUS (SUCC n) m)=(SUCC (PLUS n m)).

AddIso plus PLUS.
Hint Rewrite PLUS_1 : simplification.
Hint Rewrite PLUS_2 : simplification. 

Translate plus_n_O into PLUS_n_O.
(* translates a proof plus_n_O that forall n:nat, plus n O=n *)
(* into a proof PLUS_n_O that forall n:NAT, (PLUS n ZERO)=n  *)
