(****************************************************************************)
(*       Translation (extracts iota reduction steps and then translates)    *)
(****************************************************************************)

(* Author: Nicolas Magaud *)
(* $Id: translate.ml,v 1.16 2006/01/22 15:08:59 magaud Exp $ *)
open Isomorphism;; 
open Case_analyser;;

open Pp;;
open Term;;
open Names;;
open Evd;;
open Pfedit;;
open Tactics;;
open Tacticals;;
open Auto;;
open Typeops;;
open Printer;;
open Sign;;
open Environ;;
open Reductionops;;
open Nameops;;
open Nametab;;
open Global;;
open Libnames;;
open Decl_kinds;; (* pas de .mli *)
open Util;; (* pr_int *)

(*exception Not_typable;;*)
(*exception App_exception;;*)
let debug = ref false;;

exception Local of string;;
let failwith s = raise (Local(s));;

let drop_context c = ();;

let db_type_of s the_env the_term = 
  try (fst (infer the_env the_term)).uj_type with
      e ->  (msgnl ((str ("Type exception raised in "^s^" on term: "))++(prterm the_term));raise e)
;;

(*let initial_env() = ENVIRON(([],[]),[]);;*)

let first_of_3 t = match t with (a,b,c) ->  a;;
let last_of_3 t = match t with (a,b,c) ->  c;;

let list_idents_env the_env = (List.map first_of_3 (Environ.named_context the_env));;
let list_idents_named_context nc = (List.map first_of_3 nc);;

(* closure *)
(*- : Term.types -> *)
(*   Environ.env -> *)
(*   (Names.variable * 'a * 'b) list -> Sign.named_context *)
(* builds the list of unbound variables in a term *)
(* it does not actually perform the closure of a term with respect to its free variables *)
(* this work is delegated to check_and_rewrite, which both closes the term and apply it *)
(* to the right parameters *)
(* we reverse the context returned by closure because of some dependency issues, it is just a hack *) 
let reverse_named_context ctxt =
  Environ.fold_named_context_reverse 
    (fun e nd -> (push_named nd e)) 
    ~init:empty_env 
    ctxt

(* val add_rew_thms : *)
(*  Sign.named_context -> init:Environ.env -> Environ.env = <fun> *)

let add_rew_thms = Sign.fold_named_context push_named ;;

let closure term pf_context params =
  let new_sign = ref empty_env
  in let rec aux_closure term context =
      (match 
         begin
           if !debug then msgnl ((str "term being closed: ")++(prterm term));
           (kind_of_term term) 
         end
       with
         | Var(id) -> 
             (if (List.mem id (list_idents_env context))
                || (List.mem id (list_idents_env !new_sign)) (* variables from the closure *)
                (*|| (List.mem id (list_idents_named_context params))*) (* params are rew_rules *)
              then context 
              else 
                let new_entry = 
                  try 
                    begin
                      if !debug then msgnl ((str "A new var is used in the closure: ")++
                               (prterm (mkVar id)));
                      Environ.lookup_named id (add_rew_thms params pf_context)
                    end
                  with Not_found -> 
                    begin 
                      msgnl ((str "missing id: ")++(pr_id id));
                      msgnl ((str "context: ")++(pr_context_of pf_context));
                      failwith "closure" 
                    end
                in let new_context = (aux_closure (last_of_3 new_entry) context)
                in (new_sign:=(push_named new_entry !new_sign));new_context)
         | Rel(t) -> failwith "erreur Rel in closure"
         | Prod((Name name_var),type_var,body) ->
             let new_context = (aux_closure type_var context)
             in (aux_closure 
                   (subst1 (mkVar name_var) body) 
                   (push_named (name_var,None,type_var) new_context))
         | Prod(Anonymous,type_var,body) -> 
             let new_context = (aux_closure type_var context)
             in (aux_closure body new_context)
         | Lambda((Name name_var),type_var,body) -> 
             let new_context = (aux_closure type_var context)
             in (aux_closure 
                   (subst1 (mkVar name_var) body) 
                   (push_named (name_var,None,type_var) new_context))
         | Lambda(Anonymous,type_var,body) -> 
             let new_context = (aux_closure type_var context)
             in (aux_closure body new_context)
         | App(c1,constr_array) -> 
             begin
               (List.iter 
                  (function t -> drop_context (aux_closure t context))
                  (c1::(Array.to_list constr_array))); 
               context
             end
         | Const(c) -> context
         | _ -> context)            
  in begin 
      drop_context (aux_closure term empty_env) ;
      (Environ.named_context (reverse_named_context !new_sign))
    end;;

(* first_arg : constr -> constr *)
(* yields the first product variable type, raises an exception otherwise *)

let first_arg type0 =
  match (kind_of_term type0) with
    | Prod(_,type_var,_) -> type_var
    | _ -> failwith "first_arg: not a product!"
;;


(* we should check whether the sort of t is Prop, it is not implemented yet *)
let rec eta_form theterm thetype context =
  (match 
     begin
       if !debug then msgnl ((str "Input for eta_form: ")++(prterm thetype));
       (kind_of_term thetype)
     end 
 with 
		   | Prod(Anonymous,tv,body) -> 
		       let new_name = (next_ident_away 
                           (id_of_string "ht") 
                           (list_idents context))
         in let new_context = (push_named (new_name,None,tv) context)
         in let changed_var = (eta_form (mkVar new_name) tv new_context)
         in let new_body = mkApp (theterm, (Array.of_list [changed_var]))
         in let new_type = db_type_of "eta_form" new_context new_body
         in mkNamedLambda new_name tv (eta_form new_body new_type new_context)
		   | Prod((Name n),tv,body) ->
		       let new_name = (next_ident_away n (list_idents context)) 
		       in let new_context = (push_named (new_name,None,tv) context)
         in let changed_var = (eta_form (mkVar new_name) tv new_context)
         in let  new_body = mkApp (theterm, (Array.of_list [changed_var]))
         in let new_type = db_type_of "eta_form" new_context new_body
         in mkNamedLambda new_name tv (eta_form new_body new_type new_context)
		   | _ -> theterm)
    
(* check_beta : Term.constr -> Term.constr -> Term.context -> bool *)
 
let print_kind_of_term c =
match (kind_of_term c) with
  | Rel(_) ->  print_string "PKT:Rel"
  | Var(_) ->  print_string "PKT:Var"
  | Meta(_) -> print_string "PKT:Meta"
  | Evar(_) -> print_string "PKT:EVar"
  | Sort(_) -> print_string "PKT:Sort"
  | Cast(_,_) -> print_string "PKT:Cast"
  | Prod(n,t,b) -> print_string "PKT:Prod"
  | Lambda(n,t,b) -> print_string "PKT:Lambda"
  | LetIn(_,_,_,_) -> print_string "PKT:LetIn"
  | App(a,b) -> print_string "PKT:App"
  | Const(_) -> print_string "PKT:Constant"
  | Ind(_) -> print_string "PTK:Inductive"
  | Construct(_) -> print_string "PKT:Construct"
  | Case(_,_,_,_) -> print_string "PKT:Case"
  | Fix(_) -> print_string "PKT:Fix"
  | CoFix(_) -> print_string "PKT:CoFix";;

let rec my_eq_constr_extra t1 t2 =
  match (kind_of_term t1, kind_of_term t2) with
    | Sort(Prop(_)),Sort(Prop(_)) -> true
    | Sort(Prop(_)),Sort(Type(_)) -> true 
        (* Set and Prop are subtypes of Type *)
    | Sort(Type(i)),Sort(Type(j)) -> true 
        (*(Univ.sup i j)==j*) (* Type hierarchy *)
        (*    | Sort(_),Sort(_) -> true *)
    | Prod(Anonymous,tv1,b1), Prod(Anonymous, tv2, b2) -> 
        my_eq_constr tv1 tv2 && my_eq_constr b1 b2
    | Prod((Name n),tv1,b1), Prod(Anonymous, tv2, b2) -> 
        my_eq_constr tv1 tv2 && my_eq_constr b1 b2
    | Prod((Name n1),tv1,b1), Prod((Name n2), tv2, b2) -> 
        my_eq_constr tv1 tv2 && my_eq_constr b1 b2
    | _,_ -> 
        begin
          if !debug then msgnl ((prterm t1)++(str " not my_eq_const ")++(prterm t2));
          if !debug then print_kind_of_term t1;
          if !debug then print_kind_of_term t2;
          false
        end
and my_eq_constr t1 t2 =
  (eq_constr t1 t2) or (my_eq_constr_extra t1 t2)
;;

let check_beta exp_type pf_term context =
  let pf_type = (db_type_of "check_beta" context pf_term) 
  in if (my_eq_constr (* \alpha-conversion *)
           ((local_strong whd_beta) pf_type)  
           ((local_strong whd_beta) exp_type)) 
   (*or ((eq_constr pf_type mkProp) && (eq_constr exp_type (mkSort types)))*)
    then None 
    else begin
      if !debug 
      then msgnl ((str "check_beta: exp: ")++(prterm exp_type)++
                    (str " type: ")++(prterm pf_type));
		    Some (mkArrow pf_type exp_type)
       end;;


(* build_proof_without_iota : *)
(*    string -> Term.constr -> Term.constr -> Term.constr * Term.context *)

(* rew_thms will be stored in a named_context *)
let build_proof_without_iota (*name*) name' pf_term exp_type =
  let rew_thms = (ref empty_named_context) 
  and rew_thms_num = ref 0 in 
  let rec check_and_rewrite pf_term exp_type context =
    (match (check_beta exp_type pf_term (add_rew_thms !rew_thms context)) with
       | None -> 
           begin
             if !debug then msgnl (str "Exiting check_and_rewrite: no rewrite required");
             pf_term
           end
       | Some(type_rw) -> 
           begin
             if !debug then msgnl ((str "rewriting as follows: ")++(prterm type_rw));
             let new_name = 
               make_ident (name'^"_rr") (Some (rew_thms_num:=!rew_thms_num+1;!rew_thms_num))
             and clos = (closure type_rw context !rew_thms) in 
             let type_rw' = (List.fold_right 
                               (function
                                    (id,_,type0) -> (mkNamedProd id type0))
                               clos type_rw)
             in (*let type_of_new_name = 
                  db_type_of "check_and_rewrite" (add_rew_thms !rew_thms context) type_rw'
		                in*) 
               begin
                 if !debug then 
                   msgnl (str ("Exiting check_and_rewrite #")++
                             (pr_int !rew_thms_num)++
                             (str " : ")++(prterm type_rw')); 
	       	        (rew_thms := add_named_decl (new_name,None,type_rw') !rew_thms ;
                  mkApp ((mkVar new_name),
                   	     (Array.of_list (List.append (List.map (function x -> (mkVar (first_of_3 x))) clos)
					                                      [pf_term]))))
                   
               end
           end)
     and aux_build pf_term exp_type context = 
(* the type is reduced to a product via whd_beta *)
       match 
         begin
           if !debug then msgnl ((str "Input term for aux_build: ")++(prterm pf_term)
		                ++(str " type: ")++(prterm exp_type));
	          kind_of_term pf_term,kind_of_term (whd_betadelta context empty exp_type) 
         end
       with
         | Lambda((Name name_var1),type_var1,body1) , Prod((Name name_var2),type_var2,body2) -> 
(*             let type_judgement =  
               try (fst (infer (add_rew_thms !rew_thms context) type_var2)).uj_type 
               with Not_found -> failwith "aux_build: Named Lambda"*)
             let new_name1 = (next_ident_away name_var1 (list_idents context)) 
             and sort = db_type_of "sort" (add_rew_thms !rew_thms context) type_var2
             in
           (* We get the abstraction variable name for the term, *)
           (* but its type is enforced by the exp type *)
               mkNamedLambda 
                 new_name1
                 (aux_build type_var2 sort context)
                 (aux_build 
                    (subst1 (mkVar new_name1) body1)
                    (subst1 (mkVar new_name1) body2)
                    (push_named (new_name1,None,type_var2) context))

         | Lambda((Name name_var),type_var1,body1) , Prod(Anonymous,type_var2,body2) -> 
             (*let type_judgement =  
               try (fst (infer (add_rew_thms !rew_thms context) type_var2)).uj_type 
               with Not_found -> failwith "aux_build: Named Lambda"*)
             let new_name = (next_ident_away name_var (list_idents context)) 
             and sort = db_type_of "sort" (add_rew_thms !rew_thms context) type_var2 in
           (* We get the abstraction variable name for the term, *)
           (* but its type is enforced by the exp type *)
               mkNamedLambda 
                 new_name
                 (aux_build type_var2 sort context)
                 (aux_build 
                    (subst1 (mkVar new_name) body1) 
                    (subst1 (mkVar new_name) body2)
                    (push_named (new_name,None,type_var2) context))
                 
         | Lambda(Anonymous,type_var1,body1) , Prod(_,type_var2,body2) -> 
             let new_name = (next_ident_away (id_of_string "anon") (list_idents context)) 
             and sort = db_type_of "sort" (add_rew_thms !rew_thms context) type_var2 in

             (*let type_var_judgement = 
               try fexecute_type (mt_evd()) (add_rew_thms !rew_thms context) type_var1 with Not_found -> failwith "DD"
             in*) mkLambda (Anonymous,(aux_build type_var2 sort context),
                   (aux_build 
                      (subst1 (mkVar new_name) body1)
                      (subst1 (mkVar new_name) body2)
                      (push_named (new_name,None,type_var2) context)))
             
         | Prod((Name name_var),type_var,body) , Sort(mk_Prop) -> 
             let new_name = (next_ident_away name_var (list_idents context)) 
             in mkNamedProd new_name type_var body
               
         | Prod(Anonymous,type_var,body) , Sort(mk_Prop) -> 
             let new_name = 
               next_ident_away (id_of_string "anon") (list_idents context) 
             in mkNamedProd new_name type_var body
               
         | App(c1,constr_array) , _ ->
	            let rec application_handler first_terms app_type terms_app context = 
               begin	              
                 if !debug then msgnl ((str "Application with head: ")++(prterm first_terms));
		               match terms_app with
                     h::r -> 
                       let type_first_arg = 
		                     first_arg (whd_betadelta context empty app_type) in 
                       let recursive_computation = aux_build h type_first_arg context in 
                       let check_and_rewrite_calcul = 
                         begin
                           if !debug then msgnl (str "Entering check_and_rewrite (from app):");
			                        if !debug then msgnl ((str "first arg (term): ")++(prterm h)++
                                                   (str " (type): ")++(prterm type_first_arg));
                           (check_and_rewrite recursive_computation type_first_arg context)
			                      end in
                       let new_term = mkApp (first_terms, (Array.of_list [check_and_rewrite_calcul])) in 
                       let new_type = 
                         whd_betadelta context empty
                           (db_type_of "new_type" 
			                           (add_rew_thms !rew_thms context)
			                           new_term) in 
                       let next_terms = 
                         application_handler new_term new_type r context
                       in check_and_rewrite_calcul::next_terms
                   | [] -> []
               end
             in (* le type de la tte est synthtis *)
	            let exp_type_c1 = (fst (Typeops.infer (add_rew_thms !rew_thms context) c1)).uj_type
	            in let new_c1 = 
                  if (isConst c1) 
                  then check_and_rewrite c1 exp_type_c1 context
                  else aux_build c1 exp_type_c1 context 
             in let calcul_application = 
                  (application_handler new_c1 exp_type_c1 (Array.to_list constr_array) context)
             in (check_and_rewrite (mkApp (new_c1, (Array.of_list calcul_application))) exp_type context)
(* in application, c1 is supposed to be a identifier *)
(* (no conversion is seeked inside the term) *)
(* end of application *)
         | Const(c) , _ ->  
             begin
               if !debug then msgnl (str "Const1");  
               let itstype  = db_type_of "const1" context pf_term
               in match (kind_of_term itstype) with 
                 | Prod(_,_,_) -> 
                     (aux_build (eta_form pf_term itstype context) exp_type context)
                 | _ -> (check_and_rewrite (mkConst c)exp_type context)
             end
        (* because some proofs are performed by exact using convertibility of types *)
             (*         | Var(id) , _ -> 
                  (msgnl (str "Var1");
                    let itstype  = db_type_of "var1" context pf_term
          in match (kind_of_term itstype) with 
         | Prod(_,_,_) -> (aux_build (eta_form pf_term itstype context) exp_type context)
         | _ -> (check_and_rewrite (mkVar id) exp_type context))*)
               
         | Ind(i) , _ -> 
             begin 
               if !debug then msgnl (str "Ind");
               mkInd i 
             end
         | Construct(c) , _ -> 
             begin 
               if !debug then msgnl (str "Construct");
               mkConstruct c
             end
         | Var(id) , _ -> 
             begin
               if !debug then msgnl (str "Var");
               (check_and_rewrite (mkVar id) exp_type context)
             end
         (* Because of possible mismatches between abstraction *)
         (* variable types for \lambda and \pi                 *)
         (* we must ensure expected and proposed type          *)
         (* are the same (id's sort should be Prop)            *)
         | Case(annot,p,v,constr_array) , _ -> 
             failwith "match ... with not handled at all; use 'RemoveCases term.' first!"             
         | Sort s , Sort s' -> 
             begin
               if !debug then msgnl (str "Sort");
               mkSort s
             end
	        | LetIn(Anonymous,t1,t2,t3),t -> (* we make a \beta-redex instead *)
	            begin
               if !debug then msgnl (str "LetIn (Anonymous) ...");
	              let update_t1 = aux_build t1 t2 context 
	              and inside_term = 
                 let new_name = (next_ident_away (id_of_string "anon") (list_idents context))
                 in aux_build 
				                  (subst1 (mkVar new_name) t3)
				                  exp_type
				                  context 
	              in (check_and_rewrite 
                     (mkLetIn (Anonymous, update_t1,t2, inside_term)) 
                     exp_type 
                     context) 
             end
	        | LetIn(Name(id),t1,t2,t3),t -> (* we make a \beta-redex instead *)
	            begin 
               if !debug then msgnl (str "LetIn (Named) ...");
	              let update_t1 = aux_build t1 t2 context in
               let new_name = (next_ident_away id (list_idents context)) in
	              let inside_term = 
                 aux_build 
				               (subst1 (mkVar new_name) t3)
				               exp_type
				               (push_named (new_name,None,t2) context)
	              in (check_and_rewrite 
                     (mkNamedLetIn new_name update_t1 t2 inside_term) 
                     exp_type 
                     context) 
             end
               
         | Fix((recindxs,i), (funnames, typarray, bodies)), _ -> 
             (* for the time being we also return mkApp (f, A) *)
             let c = global_reference (out_name (funnames.(0)))
             in mkApp (c, (Array.make 1 (mkVar (id_of_string "A"))))
         | _ , _ -> 
             begin 
               msgnl (str " --- ERROR ---");
               msgnl ((str "pf_term: ")++prterm pf_term);
               msgnl ((str "exp_type: ")++(prterm exp_type));
		             msgnl (str " --- ERROR ---");
               failwith "No specified behavior for these constructions!"
             end
  in let pf_without_iota =
      (try 
         (aux_build pf_term exp_type (env()))
       with Not_found -> 
         begin
           msgnl (pr_named_context_of (env_of_context !rew_thms));
           failwith "Faulty"
         end)
  in (pf_without_iota,!rew_thms);;


(* Once iota-conversion has been removed from the term, *)
(* we translate it and the generated proof obligations  *)
(* the iso table contains only basenames for data. As a consequence, *)
(* we just handle short qualid *)
(* (nat instead of Coq.Init.Datatypes.nat *)

let rec translate constr_term str_list iso_t =
  match 
    begin
      if !debug then msgnl ((str "Input for translate: ")++(prterm constr_term));
      (kind_of_term constr_term) 
    end
    with 
    Rel(i) -> (mkRel i)
  | Meta(m) -> (mkMeta m)
  | Var(id) -> 
      if (List.mem (string_of_id id) str_list) 
      then (global_reference id)
      else (mkVar id)
  | Sort(s) -> (mkSort s)
  | Cast(c1,c2) -> 
      mkCast ((translate c1 str_list iso_t), (translate c2 str_list iso_t))
  | Prod((Name name_var),type_var,body) -> 
      (mkNamedProd name_var (translate type_var str_list iso_t) (translate body str_list iso_t))
  | Prod(Anonymous,type_var,body) -> 
      mkProd (Anonymous, (translate type_var str_list iso_t), (translate body str_list iso_t))
  | Lambda((Name name_var),type_var,body) -> 
      (mkNamedLambda name_var (translate type_var str_list iso_t) (translate body str_list iso_t))
  | Lambda(Anonymous,type_var,body) -> 
      mkLambda (Anonymous, (translate type_var str_list iso_t), (translate body str_list iso_t))
  | LetIn(Anonymous,t1,t2,t3) -> 
	     mkLetIn (Anonymous, 
               (translate t1 str_list iso_t),
               (translate t2 str_list iso_t),
               (translate t3 str_list iso_t))
  | LetIn(Name(id),t1,t2,t3) ->
	     mkNamedLetIn 
        id 
        (translate t1 str_list iso_t)
        (translate t2 str_list iso_t)
        (translate t3 str_list iso_t)
  | App(c1,constr_array) -> 
      mkApp
        ((translate c1 str_list iso_t),
         (Array.map 
            (function x -> (translate x str_list iso_t))
            constr_array))
  | Const(c) -> 
	     (try 
         let ident_constant = 
           id_of_global (reference_of_constr (mkConst c)) 
         in global_qualified_reference
              (make_short_qualid (lookup_iso ident_constant iso_t))
	      with Not_found -> 
         begin
           if !debug then msgnl (str "not an iso-constant!");
           mkConst c
         end)
  | Ind(i) -> 
	     (try 
        let ident_ind = id_of_global (reference_of_constr (mkInd i))
        in 
        global_qualified_reference 
          (make_short_qualid (lookup_iso ident_ind iso_t))
	     with Not_found (*Isomorphism.Not_found*) -> 
        begin
          if !debug then msgnl (str "not an iso-inductive!");
          mkInd i
        end)
  | Construct(c) ->
	     (try 
	       let ident_construct = 
          id_of_global (reference_of_constr (mkConstruct c))
        in global_qualified_reference 
	         (make_short_qualid (lookup_iso ident_construct iso_t))
	     with Not_found -> 
        begin
          if !debug then msgnl (str "not an iso-constructor!");
          mkConstruct c
        end)
  | Case(annot,c1,c2,constr_array) ->
      mkCase (annot, 
           	  (translate c1 str_list iso_t),
           	  (translate c2 str_list iso_t), 
           	  (Array.map (function x -> (translate x str_list iso_t)) constr_array))
  | Fix((recindxs,i), (funnames, typarray, bodies)) -> 
(try 
  begin
    msgnl (str "Translating Fix");
    let c = out_name (funnames.(0)) in 
    let updated_name = lookup_iso c iso_t
    in mkApp (mkVar updated_name, (Array.make 1 (mkVar (id_of_string "A"))))
  end
with Not_found -> constr_term)
(* those cases are not considered yet ! *)
(*      | IsFix(recindxs,i,jtypsarray,funnames,bodies) ->  
   (mkFix recindxs i jtypsarray funnames bodies)
   | IsCoFix(i,jtypsarray,funnames,bodies) ->
   (mkCoFix i jtypsarray funnames bodies) 
 *)   
  | _ -> failwith "Undefined case in translate"
;;

open Closure;;
open RedFlags;;

let betadelta = mkflags [fBETA;fDELTA]
let ww = ref (mkRel 12);;

(* starting the goal, proving it through tactics, adding a new constant  *)
let solve_obligation id constr0 =
  begin
    ww:=constr0;
    if !debug then msgnl (str "solve_obligation");
    Pfedit.start_proof 
      id 
      (IsGlobal(Proof Fact))
      (Environ.named_context (Global.env())) 
      constr0 
      (fun _ _ -> ());
    msg (str ("Solving "^(string_of_id id)^"..."));
    if !debug then msgnl (prterm constr0);
    (*try*) Pfedit.by 
    (tclORELSE
       (tclTHEN (Auto.full_auto 12)
          (tclFAIL 0 "failed"))
       (tclTHEN 
          (tclREPEAT 
             (tclTHEN 
                (tclTHEN 
                   (reduct_in_concl (fun tenv tevar_map -> Tacred.cbv_beta))
                   (Autorewrite.autorewrite 
                      tclIDTAC [ "simplification" ]))
                intro)) 
          
          (tclORELSE
             
             (tclTHEN 
                (tclTHEN 
                   (tclTHEN 
                      (reduct_in_concl (fun tenv tevar_map -> Tacred.cbv_beta)) (* simpl_in_concl *)
                      (Autorewrite.autorewrite tclIDTAC [ "simplification" ])) 
                   (Auto.full_auto 12)) 
                (tclFAIL 0 "failed2"))
             
             (tclTHEN 
                (tclTHEN 
                   (tclTHEN 
                      (reduct_in_concl (fun tenv tevar_map -> (strong whd_betadelta) tenv tevar_map)) (* simpl_in_concl *)
                      (Autorewrite.autorewrite tclIDTAC [ "simplification" ])) 
                   (Auto.full_auto 12))
                (tclFAIL 0 "failed3")))));
    
    try 
      begin
        Command.save_named false;
        msgnl (str " solved!");
      end
    with _ -> (begin msgnl (str "-- save failed --");() end)
  end
;;

(* Translation and display of the Coq code to be used *)
let main_translate qualid_exp qualid_exp' iso_t = 
  let the_term = 
    try get_proof_term qualid_exp
    with Not_found -> 
      failwith ((string_of_qualid qualid_exp)^" does not exist! (apparently...)")
  and the_type = type_of_global (locate qualid_exp)
(*  and thm_name = string_of_qualid qualid_exp *)
  and thm_name' = string_of_qualid qualid_exp' in
  let the_term_without_nondep_cases = 
    begin
      msg ((str "Removing explicit pattern-matching in ")++
               (pr_qualid qualid_exp)++
            (str "..."));
      let r = search_and_replace_cases the_term (Global.env())
      in begin
          msgnl (str " done!");
          r
        end
    end
  in 
  let (pretty_term,rews_named_context) = 
    build_proof_without_iota (*thm_name*) thm_name' the_term_without_nondep_cases (**) the_type
  in 
    begin 
      if !debug then msgnl (str "proof obligations ready to be proved");
      if !debug then msgnl ((str "#Obligations to be proved:")++
               (pr_int (List.length rews_named_context)));
      List.iter 
        (function (id,_,tj) -> 
           begin
             if !debug then msgnl ((pr_id id)++(str ": ")++(prterm tj));
             (solve_obligation id (translate tj [] iso_t))
           end)
        (List.rev rews_named_context);
      
      if !debug then msgnl ((str "type:")++(prterm (translate the_type [] iso_t)));
      let term_to_print = 
        translate 
          pretty_term 
          (List.map 
             string_of_id 
             (list_idents_named_context rews_named_context))
          iso_t
      in if !debug then msgnl ((str "term:")++(prterm term_to_print));
      Pfedit.start_proof 
        (id_of_string thm_name')
        (IsGlobal(Proof Fact))
        Sign.empty_named_context 
        (translate the_type [] iso_t)
        (fun _ _ -> ());
      (*show_constr (translate pretty_term (List.map string_of_id rewsl));*)
      by (Tactics.exact_check 
            (translate 
               pretty_term 
               (List.map string_of_id (list_idents_named_context rews_named_context))
               iso_t));
      Command.save_named (*true*) false;
      msgnl ((pr_id (id_of_string thm_name'))++
               (str " was successfully translated and defined."))
    end

  ;;

(*translate  term list (* changes Var into Const for bidon_rr1\ldots *)*)

let init_translate i1 = 
  let c = make_short_qualid i1 
  and c'= make_short_qualid (id_of_string ((string_of_id i1)^"'"))
  in (main_translate c c' !iso_table);;

let translate_and_add i1 i2 = 
  let c = make_short_qualid i1 
  and c'= make_short_qualid i2
  in (main_translate c c' !iso_table);;


VERNAC COMMAND EXTEND Translate2
  [ "Translate" ident(i1) "into" ident(i2) ]
     -> [ translate_and_add i1 i2 ]
  END

VERNAC COMMAND EXTEND Translate
  [ "Translate" ident(i1) ]
     -> [ init_translate i1 ]
  END


(* $Id: *)

(*i
 Local Variables:
 compile-command: "make -k translate.cmo"
 tab-width: 1
 indent-tabs-mode: nil
 fill-column: 85
 End:
i*)
